/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.factorization;

import org.carrot2.matrix.factorization.IMatrixFactorizationFactory;
import org.carrot2.matrix.factorization.seeding.ISeedingStrategy;
import org.carrot2.matrix.factorization.seeding.ISeedingStrategyFactory;
import org.carrot2.matrix.factorization.seeding.RandomSeedingStrategyFactory;

public abstract class IterativeMatrixFactorizationFactory
implements IMatrixFactorizationFactory {
    protected int k = 15;
    protected static final int DEFAULT_K = 15;
    protected int maxIterations = 15;
    protected static final int DEFAULT_MAX_ITERATIONS = 15;
    protected double stopThreshold = -1.0;
    protected static final double DEFAULT_STOP_THRESHOLD = -1.0;
    protected ISeedingStrategyFactory seedingFactory = DEFAULT_SEEDING_FACTORY;
    protected static final ISeedingStrategyFactory DEFAULT_SEEDING_FACTORY = new RandomSeedingStrategyFactory(0);
    protected boolean ordered = true;
    protected static final boolean DEFAULT_ORDERED = true;

    public void setK(int k) {
        this.k = k;
    }

    public int getK() {
        return this.k;
    }

    protected ISeedingStrategy createSeedingStrategy() {
        return this.seedingFactory.createSeedingStrategy();
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public double getStopThreshold() {
        return this.stopThreshold;
    }

    public void setStopThreshold(double stopThreshold) {
        this.stopThreshold = stopThreshold;
    }

    public ISeedingStrategyFactory getSeedingFactory() {
        return this.seedingFactory;
    }

    public void setSeedingFactory(ISeedingStrategyFactory seedingFactory) {
        this.seedingFactory = seedingFactory;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }
}

