/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.FloatFloatProcedure;
import org.apache.mahout.math.function.FloatFunction;
import org.apache.mahout.math.function.FloatProcedure;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.set.AbstractSet;

public abstract class AbstractFloatFloatMap
extends AbstractSet {
    public boolean containsKey(final float key) {
        return !this.forEachKey(new FloatProcedure(){

            public boolean apply(float iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final float value) {
        return !this.forEachPair(new FloatFloatProcedure(){

            public boolean apply(float iterKey, float iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractFloatFloatMap copy() {
        return (AbstractFloatFloatMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractFloatFloatMap)) {
            return false;
        }
        final AbstractFloatFloatMap other = (AbstractFloatFloatMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new FloatFloatProcedure(){

            public boolean apply(float key, float value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new FloatFloatProcedure(){

            public boolean apply(float key, float value) {
                return AbstractFloatFloatMap.this.containsKey(key) && AbstractFloatFloatMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(FloatProcedure var1);

    public boolean forEachPair(final FloatFloatProcedure procedure) {
        return this.forEachKey(new FloatProcedure(){

            public boolean apply(float key) {
                return procedure.apply(key, AbstractFloatFloatMap.this.get(key));
            }
        });
    }

    public abstract float get(float var1);

    public FloatArrayList keys() {
        FloatArrayList list = new FloatArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final FloatArrayList list) {
        list.clear();
        this.forEachKey(new FloatProcedure(){

            public boolean apply(float key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(FloatArrayList keyList) {
        this.pairsSortedByValue(keyList, new FloatArrayList(this.size()));
    }

    public void pairsMatching(final FloatFloatProcedure condition, final FloatArrayList keyList, final FloatArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new FloatFloatProcedure(){

            public boolean apply(float key, float value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(FloatArrayList keyList, FloatArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(FloatArrayList keyList, FloatArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final float[] k = keyList.elements();
        final float[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                float t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                float t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(float var1, float var2);

    public abstract boolean removeKey(float var1);

    public String toString() {
        FloatArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            float key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        FloatArrayList theKeys = new FloatArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            float key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public FloatArrayList values() {
        FloatArrayList list = new FloatArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final FloatArrayList list) {
        list.clear();
        this.forEachKey(new FloatProcedure(){

            public boolean apply(float key) {
                list.add(AbstractFloatFloatMap.this.get(key));
                return true;
            }
        });
    }

    public void assign(final FloatFunction function) {
        this.copy().forEachPair(new FloatFloatProcedure(){

            public boolean apply(float key, float value) {
                AbstractFloatFloatMap.this.put(key, function.apply(value));
                return true;
            }
        });
    }

    public void assign(AbstractFloatFloatMap other) {
        this.clear();
        other.forEachPair(new FloatFloatProcedure(){

            public boolean apply(float key, float value) {
                AbstractFloatFloatMap.this.put(key, value);
                return true;
            }
        });
    }

    public float adjustOrPutValue(float key, float newValue, float incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = this.get(key) + incrValue;
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

