/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.matrix.impl;

import org.apache.mahout.math.matrix.impl.AbstractMatrix;

@Deprecated
public abstract class AbstractMatrix2D
extends AbstractMatrix {
    protected int columns;
    protected int rows;
    protected int rowStride;
    protected int columnStride;
    protected int rowZero;
    protected int columnZero;

    protected AbstractMatrix2D() {
    }

    protected int columnOffset(int absRank) {
        return absRank;
    }

    protected int columnRank(int rank) {
        return this.columnZero + rank * this.columnStride;
    }

    protected int rowOffset(int absRank) {
        return absRank;
    }

    protected int rowRank(int rank) {
        return this.rowZero + rank * this.rowStride;
    }

    protected void checkBox(int row, int column, int height, int width) {
        if (column < 0 || width < 0 || column + width > this.columns || row < 0 || height < 0 || row + height > this.rows) {
            throw new IndexOutOfBoundsException("Column:" + column + ", row:" + row + " ,width:" + width + ", height:" + height);
        }
    }

    protected void checkColumn(int column) {
        if (column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException("Attempted to access at column=" + column);
        }
    }

    protected void checkColumnIndexes(int[] indexes) {
        int i = indexes.length;
        while (--i >= 0) {
            int index = indexes[i];
            if (index >= 0 && index < this.columns) continue;
            this.checkColumn(index);
        }
    }

    protected void checkRow(int row) {
        if (row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("Attempted to access at row=" + row);
        }
    }

    protected void checkRowIndexes(int[] indexes) {
        int i = indexes.length;
        while (--i >= 0) {
            int index = indexes[i];
            if (index >= 0 && index < this.rows) continue;
            this.checkRow(index);
        }
    }

    public void checkShape(AbstractMatrix2D B) {
        if (this.columns != B.columns || this.rows != B.rows) {
            throw new IllegalArgumentException("Incompatible dimensions");
        }
    }

    public int columns() {
        return this.columns;
    }

    protected int index(int row, int column) {
        return this.rowOffset(this.rowRank(row)) + this.columnOffset(this.columnRank(column));
    }

    public int rows() {
        return this.rows;
    }

    protected void setUp(int rows, int columns) {
        this.setUp(rows, columns, 0, 0, columns, 1);
    }

    protected void setUp(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        if (rows < 0 || columns < 0) {
            throw new IllegalArgumentException("negative size");
        }
        this.rows = rows;
        this.columns = columns;
        this.rowZero = rowZero;
        this.columnZero = columnZero;
        this.rowStride = rowStride;
        this.columnStride = columnStride;
        this.isNoView = true;
        if ((double)columns * (double)rows > 2.147483647E9) {
            throw new IllegalArgumentException("matrix too large");
        }
    }

    @Override
    public int size() {
        return this.rows * this.columns;
    }

    protected AbstractMatrix2D vColumnFlip() {
        if (this.columns > 0) {
            this.columnZero += (this.columns - 1) * this.columnStride;
            this.columnStride = -this.columnStride;
            this.isNoView = false;
        }
        return this;
    }

    protected AbstractMatrix2D vDice() {
        int tmp = this.rows;
        this.rows = this.columns;
        this.columns = tmp;
        tmp = this.rowStride;
        this.rowStride = this.columnStride;
        this.columnStride = tmp;
        tmp = this.rowZero;
        this.rowZero = this.columnZero;
        this.columnZero = tmp;
        this.isNoView = false;
        return this;
    }

    protected AbstractMatrix2D vPart(int row, int column, int height, int width) {
        this.checkBox(row, column, height, width);
        this.rowZero += this.rowStride * row;
        this.columnZero += this.columnStride * column;
        this.rows = height;
        this.columns = width;
        this.isNoView = false;
        return this;
    }

    protected AbstractMatrix2D vRowFlip() {
        if (this.rows > 0) {
            this.rowZero += (this.rows - 1) * this.rowStride;
            this.rowStride = -this.rowStride;
            this.isNoView = false;
        }
        return this;
    }
}

