/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.text.MessageFormat;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.ssl.KeyStoresFactory;
import org.apache.hadoop.security.ssl.ReloadingX509TrustManager;
import org.apache.hadoop.security.ssl.SSLFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FileBasedKeyStoresFactory
implements KeyStoresFactory {
    private static final Log LOG = LogFactory.getLog(FileBasedKeyStoresFactory.class);
    public static final String SSL_KEYSTORE_LOCATION_TPL_KEY = "ssl.{0}.keystore.location";
    public static final String SSL_KEYSTORE_PASSWORD_TPL_KEY = "ssl.{0}.keystore.password";
    public static final String SSL_KEYSTORE_TYPE_TPL_KEY = "ssl.{0}.keystore.type";
    public static final String SSL_TRUSTSTORE_RELOAD_INTERVAL_TPL_KEY = "ssl.{0}.truststore.reload.interval";
    public static final String SSL_TRUSTSTORE_LOCATION_TPL_KEY = "ssl.{0}.truststore.location";
    public static final String SSL_TRUSTSTORE_PASSWORD_TPL_KEY = "ssl.{0}.truststore.password";
    public static final String SSL_TRUSTSTORE_TYPE_TPL_KEY = "ssl.{0}.truststore.type";
    public static final String DEFAULT_KEYSTORE_TYPE = "jks";
    public static final int DEFAULT_SSL_TRUSTSTORE_RELOAD_INTERVAL = 10000;
    private Configuration conf;
    private KeyManager[] keyManagers;
    private TrustManager[] trustManagers;
    private ReloadingX509TrustManager trustManager;

    @VisibleForTesting
    public static String resolvePropertyName(SSLFactory.Mode mode, String template) {
        return MessageFormat.format(template, mode.toString().toLowerCase());
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(SSLFactory.Mode mode) throws IOException, GeneralSecurityException {
        boolean requireClientCert = this.conf.getBoolean("hadoop.ssl.require.client.cert", true);
        String keystoreType = this.conf.get(FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_TYPE_TPL_KEY), DEFAULT_KEYSTORE_TYPE);
        KeyStore keystore = KeyStore.getInstance(keystoreType);
        String keystorePassword = null;
        if (requireClientCert || mode == SSLFactory.Mode.SERVER) {
            String locationProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_LOCATION_TPL_KEY);
            String keystoreLocation = this.conf.get(locationProperty, "");
            if (keystoreLocation.isEmpty()) {
                throw new GeneralSecurityException("The property '" + locationProperty + "' has not been set in the ssl configuration file.");
            }
            String passwordProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_PASSWORD_TPL_KEY);
            keystorePassword = this.conf.get(passwordProperty, "");
            if (keystorePassword.isEmpty()) {
                throw new GeneralSecurityException("The property '" + passwordProperty + "' has not been set in the ssl configuration file.");
            }
            LOG.debug((Object)(mode.toString() + " KeyStore: " + keystoreLocation));
            FileInputStream is = new FileInputStream(keystoreLocation);
            try {
                keystore.load(is, keystorePassword.toCharArray());
            }
            finally {
                ((InputStream)is).close();
            }
            LOG.debug((Object)(mode.toString() + " Loaded KeyStore: " + keystoreLocation));
        } else {
            keystore.load(null, null);
        }
        KeyManagerFactory keyMgrFactory = KeyManagerFactory.getInstance("SunX509");
        keyMgrFactory.init(keystore, keystorePassword != null ? keystorePassword.toCharArray() : null);
        this.keyManagers = keyMgrFactory.getKeyManagers();
        String truststoreType = this.conf.get(FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_TYPE_TPL_KEY), DEFAULT_KEYSTORE_TYPE);
        String locationProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_LOCATION_TPL_KEY);
        String truststoreLocation = this.conf.get(locationProperty, "");
        if (truststoreLocation.isEmpty()) {
            throw new GeneralSecurityException("The property '" + locationProperty + "' has not been set in the ssl configuration file.");
        }
        String passwordProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_PASSWORD_TPL_KEY);
        String truststorePassword = this.conf.get(passwordProperty, "");
        if (truststorePassword.isEmpty()) {
            throw new GeneralSecurityException("The property '" + passwordProperty + "' has not been set in the ssl configuration file.");
        }
        long truststoreReloadInterval = this.conf.getLong(FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_RELOAD_INTERVAL_TPL_KEY), 10000L);
        LOG.debug((Object)(mode.toString() + " TrustStore: " + truststoreLocation));
        this.trustManager = new ReloadingX509TrustManager(truststoreType, truststoreLocation, truststorePassword, truststoreReloadInterval);
        this.trustManager.init();
        LOG.debug((Object)(mode.toString() + " Loaded TrustStore: " + truststoreLocation));
        this.trustManagers = new TrustManager[]{this.trustManager};
    }

    @Override
    public synchronized void destroy() {
        if (this.trustManager != null) {
            this.trustManager.destroy();
            this.trustManager = null;
            this.keyManagers = null;
            this.trustManagers = null;
        }
    }

    @Override
    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    @Override
    public TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }
}

