/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Throwables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheBuilder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LoadingCache;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.HashMultimap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Multimap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.SetMultimap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.AnnotatedHandlerFinder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.DeadEvent;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventBus$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventBus$2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventBus$3;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventBus$EventWithHandler;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventHandler;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.HandlerFindingStrategy;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.InvocationTargetException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventBus {
    private static final LoadingCache flattenHierarchyCache = CacheBuilder.newBuilder().weakKeys().build(new EventBus$1());
    private final SetMultimap handlersByType = HashMultimap.create();
    private final ReadWriteLock handlersByTypeLock = new ReentrantReadWriteLock();
    private final Logger logger;
    private final HandlerFindingStrategy finder = new AnnotatedHandlerFinder();
    private final ThreadLocal eventsToDispatch = new EventBus$2(this);
    private final ThreadLocal isDispatching = new EventBus$3(this);

    public EventBus() {
        this("default");
    }

    public EventBus(String string) {
        this.logger = Logger.getLogger(EventBus.class.getName() + "." + (String)Preconditions.checkNotNull(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Object object) {
        Multimap multimap = this.finder.findAllHandlers(object);
        this.handlersByTypeLock.writeLock().lock();
        try {
            this.handlersByType.putAll(multimap);
        }
        finally {
            this.handlersByTypeLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(Object object) {
        Set set = this.flattenHierarchy(object.getClass());
        boolean bl = false;
        for (Class clazz : set) {
            this.handlersByTypeLock.readLock().lock();
            try {
                Set set2 = this.handlersByType.get(clazz);
                if (set2.isEmpty()) continue;
                bl = true;
                for (EventHandler eventHandler : set2) {
                    this.enqueueEvent(object, eventHandler);
                }
            }
            finally {
                this.handlersByTypeLock.readLock().unlock();
            }
        }
        if (!bl && !(object instanceof DeadEvent)) {
            this.post(new DeadEvent(this, object));
        }
        this.dispatchQueuedEvents();
    }

    void enqueueEvent(Object object, EventHandler eventHandler) {
        ((Queue)this.eventsToDispatch.get()).offer(new EventBus$EventWithHandler(object, eventHandler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchQueuedEvents() {
        if (((Boolean)this.isDispatching.get()).booleanValue()) {
            return;
        }
        this.isDispatching.set(true);
        try {
            EventBus$EventWithHandler eventBus$EventWithHandler;
            Queue queue = (Queue)this.eventsToDispatch.get();
            while ((eventBus$EventWithHandler = (EventBus$EventWithHandler)queue.poll()) != null) {
                this.dispatch(eventBus$EventWithHandler.event, eventBus$EventWithHandler.handler);
            }
        }
        finally {
            this.isDispatching.remove();
            this.eventsToDispatch.remove();
        }
    }

    void dispatch(Object object, EventHandler eventHandler) {
        try {
            eventHandler.handleEvent(object);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.logger.log(Level.SEVERE, "Could not dispatch event: " + object + " to handler " + eventHandler, invocationTargetException);
        }
    }

    Set flattenHierarchy(Class clazz) {
        try {
            return (Set)flattenHierarchyCache.getUnchecked(clazz);
        }
        catch (UncheckedExecutionException uncheckedExecutionException) {
            throw Throwables.propagate(uncheckedExecutionException.getCause());
        }
    }
}

