/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.solr.search.EarlyTerminatingCollectorException;

public class EarlyTerminatingCollector
extends Collector {
    private int numCollected;
    private int lastDocId = -1;
    private int maxDocsToCollect;
    private Collector delegate;

    public EarlyTerminatingCollector(Collector delegate, int maxDocsToCollect) {
        this.delegate = delegate;
        this.maxDocsToCollect = maxDocsToCollect;
    }

    public boolean acceptsDocsOutOfOrder() {
        return this.delegate.acceptsDocsOutOfOrder();
    }

    public void collect(int doc) throws IOException {
        this.delegate.collect(doc);
        this.lastDocId = doc;
        ++this.numCollected;
        if (this.numCollected == this.maxDocsToCollect) {
            throw new EarlyTerminatingCollectorException(this.numCollected, this.lastDocId);
        }
    }

    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.delegate.setNextReader(context);
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.delegate.setScorer(scorer);
    }

    public int getNumCollected() {
        return this.numCollected;
    }

    public void setNumCollected(int numCollected) {
        this.numCollected = numCollected;
    }

    public int getLastDocId() {
        return this.lastDocId;
    }

    public void setLastDocId(int lastDocId) {
        this.lastDocId = lastDocId;
    }
}

