/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrCoreDiscoverer {
    protected static Logger log = LoggerFactory.getLogger(SolrCoreDiscoverer.class);
    public static final String CORE_PROP_FILE = "core.properties";

    public Map<String, CoreDescriptor> discover(CoreContainer container, File root) throws IOException {
        HashMap<String, CoreDescriptor> coreDescriptorMap = new HashMap<String, CoreDescriptor>();
        this.walkFromHere(root, container, coreDescriptorMap);
        return coreDescriptorMap;
    }

    private void walkFromHere(File file, CoreContainer container, Map<String, CoreDescriptor> coreDescriptorMap) throws IOException {
        log.info("Looking for cores in " + file.getCanonicalPath());
        if (!file.exists()) {
            return;
        }
        for (File childFile : file.listFiles()) {
            File propFile = new File(childFile, CORE_PROP_FILE);
            if (propFile.exists()) {
                this.addCore(container, childFile, propFile, coreDescriptorMap);
                continue;
            }
            if (!childFile.isDirectory()) continue;
            this.walkFromHere(childFile, container, coreDescriptorMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCore(CoreContainer container, File childFile, File propFile, Map<String, CoreDescriptor> coreDescriptorMap) throws IOException {
        CoreDescriptor desc;
        CoreDescriptor check;
        log.info("Discovered properties file {}, adding to cores", (Object)propFile.getAbsolutePath());
        Properties propsOrig = new Properties();
        FileInputStream is = new FileInputStream(propFile);
        try {
            propsOrig.load(new InputStreamReader((InputStream)is, "UTF-8"));
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        Properties props = new Properties();
        for (String prop : propsOrig.stringPropertyNames()) {
            props.put(prop, PropertiesUtil.substituteProperty(propsOrig.getProperty(prop), null));
        }
        props.setProperty("instanceDir", childFile.getCanonicalPath());
        if (props.getProperty("name") == null) {
            props.setProperty("name", childFile.getName());
        }
        if ((check = coreDescriptorMap.get((desc = new CoreDescriptor(container, props)).getName())) != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Core " + desc.getName() + " defined more than once, once in " + desc.getInstanceDir() + " and once in " + check.getInstanceDir());
        }
        coreDescriptorMap.put(desc.getName(), desc);
    }
}

