/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.stats;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.solr.util.stats.ExponentiallyDecayingSample;
import org.apache.solr.util.stats.Sample;
import org.apache.solr.util.stats.Snapshot;
import org.apache.solr.util.stats.UniformSample;

public class Histogram {
    private static final int DEFAULT_SAMPLE_SIZE = 1028;
    private static final double DEFAULT_ALPHA = 0.015;
    private final Sample sample;
    private final AtomicLong min = new AtomicLong();
    private final AtomicLong max = new AtomicLong();
    private final AtomicLong sum = new AtomicLong();
    private final AtomicReference<double[]> variance = new AtomicReference<double[]>(new double[]{-1.0, 0.0});
    private final AtomicLong count = new AtomicLong();

    Histogram(SampleType type) {
        this(type.newSample());
    }

    Histogram(Sample sample) {
        this.sample = sample;
        this.clear();
    }

    public void clear() {
        this.sample.clear();
        this.count.set(0L);
        this.max.set(Long.MIN_VALUE);
        this.min.set(Long.MAX_VALUE);
        this.sum.set(0L);
        this.variance.set(new double[]{-1.0, 0.0});
    }

    public void update(int value) {
        this.update((long)value);
    }

    public void update(long value) {
        this.count.incrementAndGet();
        this.sample.update(value);
        this.setMax(value);
        this.setMin(value);
        this.sum.getAndAdd(value);
        this.updateVariance(value);
    }

    public long getCount() {
        return this.count.get();
    }

    public double getMax() {
        if (this.getCount() > 0L) {
            return this.max.get();
        }
        return 0.0;
    }

    public double getMin() {
        if (this.getCount() > 0L) {
            return this.min.get();
        }
        return 0.0;
    }

    public double getMean() {
        if (this.getCount() > 0L) {
            return (double)this.sum.get() / (double)this.getCount();
        }
        return 0.0;
    }

    public double getStdDev() {
        if (this.getCount() > 0L) {
            return Math.sqrt(this.getVariance());
        }
        return 0.0;
    }

    public double getSum() {
        return this.sum.get();
    }

    public Snapshot getSnapshot() {
        return this.sample.getSnapshot();
    }

    private double getVariance() {
        if (this.getCount() <= 1L) {
            return 0.0;
        }
        return this.variance.get()[1] / (double)(this.getCount() - 1L);
    }

    private void setMax(long potentialMax) {
        boolean done = false;
        while (!done) {
            long currentMax = this.max.get();
            done = currentMax >= potentialMax || this.max.compareAndSet(currentMax, potentialMax);
        }
    }

    private void setMin(long potentialMin) {
        boolean done = false;
        while (!done) {
            long currentMin = this.min.get();
            done = currentMin <= potentialMin || this.min.compareAndSet(currentMin, potentialMin);
        }
    }

    private void updateVariance(long value) {
        double[] newValues;
        double[] oldValues;
        do {
            oldValues = this.variance.get();
            newValues = new double[2];
            if (oldValues[0] == -1.0) {
                newValues[0] = value;
                newValues[1] = 0.0;
                continue;
            }
            double oldM = oldValues[0];
            double oldS = oldValues[1];
            double newM = oldM + ((double)value - oldM) / (double)this.getCount();
            double newS = oldS + ((double)value - oldM) * ((double)value - newM);
            newValues[0] = newM;
            newValues[1] = newS;
        } while (!this.variance.compareAndSet(oldValues, newValues));
    }

    static enum SampleType {
        UNIFORM{

            @Override
            public Sample newSample() {
                return new UniformSample(1028);
            }
        }
        ,
        BIASED{

            @Override
            public Sample newSample() {
                return new ExponentiallyDecayingSample(1028, 0.015);
            }
        };


        public abstract Sample newSample();
    }
}

