/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.analysis.util.ResourceLoader;

class StringMockSolrResourceLoader
implements ResourceLoader {
    String text;

    StringMockSolrResourceLoader(String text) {
        this.text = text;
    }

    public <T> Class<? extends T> findClass(String cname, Class<T> expectedType) {
        try {
            return Class.forName(cname).asSubclass(expectedType);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load class: " + cname, e);
        }
    }

    public <T> T newInstance(String cname, Class<T> expectedType) {
        Class<T> clazz = this.findClass(cname, expectedType);
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create instance: " + cname, e);
        }
    }

    public InputStream openResource(String resource) throws IOException {
        return new ByteArrayInputStream(this.text.getBytes("UTF-8"));
    }
}

