@echo off

REM ==============================================================================
REM Installs SOLR as a service
REM ==============================================================================
REM Examples:
REM ---------
REM installAsService

REM Please change the following two lines if you install SOLR MORE THAN ONCE!
SET SERVICE_NAME=SOLR
SET SERVICE_DESCRIPTION=SOLR service for DataWiki
SET PLATFORM=win64

REM Check for admin rights
fsutil > nul
IF %ERRORLEVEL% NEQ 0 GOTO adminhint
goto start
:adminhint
echo You need administrator rights to run this script.
goto end
:start

IF [%1] == [/?] goto usage

set SOLR_HOME=%~dp0..
set NSSMEXE=%CD%\service\%PLATFORM%\nssm.exe

IF "%1" == "update" goto end

IF "%1" == "java_home" SET JAVA_HOME=%2
CALL :dequote JAVA_HOME

IF "%JAVA_HOME%" == "" goto nojavahome

:install
"%NSSMEXE%" install "%SERVICE_NAME%" "%JAVA_HOME%\bin\java.exe" "%SERVICE_DESCRIPTION%" "-Dsolr.solr.home=%SOLR_HOME%\wiki-solr\DataWiki" "-Djetty.home=%SOLR_HOME%\wiki-solr" "-Djetty.logs=%SOLR_HOME%\wiki-solr\logs" -cp "%SOLR_HOME%\lib\*.jar;%SOLR_HOME%\wiki-solr\start.jar" -jar "%SOLR_HOME%\wiki-solr\start.jar"

IF %ERRORLEVEL% NEQ 0 GOTO failed

timeout /t 5 >NUL
net start SOLR

goto end

:failed
@echo SOLR installation FAILED!
goto end

:nojavahome
echo No JAVA_HOME found.
goto end

:usage
echo =============================================================================
echo  Installs SOLR as a Windows service  
echo =============================================================================
echo Examples:
echo ---------
echo installAsService
echo installAsService java_home "path/to/jreOrjdk"
echo installAsService update (run this if you updated SOLR)
echo =============================================================================
goto end

:DeQuote
for /f "delims=" %%A in ('echo %%%1%%') do set %1=%%~A
Goto :end

:end
