/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.start.Main;

public class JarVersion {
    private static JarEntry findEntry(JarFile jar, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Enumeration<JarEntry> en = jar.entries();
        while (en.hasMoreElements()) {
            JarEntry entry = en.nextElement();
            Matcher matcher = pattern.matcher(entry.getName());
            if (!matcher.matches()) continue;
            return entry;
        }
        return null;
    }

    private static String getBundleVersion(Manifest manifest) {
        Attributes attribs = manifest.getMainAttributes();
        if (attribs == null) {
            return null;
        }
        String version = attribs.getValue("Bundle-Version");
        if (version == null) {
            return null;
        }
        return JarVersion.stripV(version);
    }

    private static String getMainManifestImplVersion(Manifest manifest) {
        Attributes attribs = manifest.getMainAttributes();
        if (attribs == null) {
            return null;
        }
        String version = attribs.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        if (version == null) {
            return null;
        }
        return JarVersion.stripV(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMavenVersion(JarFile jar) throws IOException {
        JarEntry pomProp = JarVersion.findEntry(jar, "META-INF/maven/.*/pom\\.properties$");
        if (pomProp == null) {
            return null;
        }
        InputStream stream = null;
        try {
            stream = jar.getInputStream(pomProp);
            Properties props = new Properties();
            props.load(stream);
            String version = props.getProperty("version");
            if (version == null) {
                String string = null;
                return string;
            }
            String string = JarVersion.stripV(version);
            return string;
        }
        finally {
            Main.close(stream);
        }
    }

    private static String getSubManifestImplVersion(Manifest manifest) {
        Map<String, Attributes> entries = manifest.getEntries();
        for (Attributes attribs : entries.values()) {
            String version;
            if (attribs == null || (version = attribs.getValue(Attributes.Name.IMPLEMENTATION_VERSION)) == null) continue;
            return JarVersion.stripV(version);
        }
        return null;
    }

    public static String getVersion(File file) {
        try {
            JarFile jar = new JarFile(file);
            String version = null;
            Manifest manifest = jar.getManifest();
            version = JarVersion.getMainManifestImplVersion(manifest);
            if (version != null) {
                return version;
            }
            version = JarVersion.getSubManifestImplVersion(manifest);
            if (version != null) {
                return version;
            }
            version = JarVersion.getBundleVersion(manifest);
            if (version != null) {
                return version;
            }
            version = JarVersion.getMavenVersion(jar);
            if (version != null) {
                return version;
            }
            return "(not specified)";
        }
        catch (IOException e) {
            return "(error: " + e.getClass().getSimpleName() + " " + e.getMessage() + ")";
        }
    }

    private static String stripV(String version) {
        if (version.charAt(0) == 'v') {
            return version.substring(1);
        }
        return version;
    }
}

