/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessorFactory;
import org.apache.solr.update.processor.FieldValueMutatingUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegexReplaceProcessorFactory
extends FieldMutatingUpdateProcessorFactory {
    private static final Logger log = LoggerFactory.getLogger(RegexReplaceProcessorFactory.class);
    private static final String REPLACEMENT_PARAM = "replacement";
    private static final String PATTERN_PARAM = "pattern";
    private Pattern pattern;
    private String replacement;

    @Override
    public void init(NamedList args) {
        Object patternParam = args.remove(PATTERN_PARAM);
        if (patternParam == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required init parameter: pattern");
        }
        try {
            this.pattern = Pattern.compile(patternParam.toString());
        }
        catch (PatternSyntaxException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid regex: " + patternParam, (Throwable)e);
        }
        Object replacementParam = args.remove(REPLACEMENT_PARAM);
        if (replacementParam == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required init parameter: replacement");
        }
        this.replacement = Matcher.quoteReplacement(replacementParam.toString());
        super.init(args);
    }

    @Override
    protected FieldMutatingUpdateProcessor.FieldNameSelector getDefaultSelector(SolrCore core) {
        return FieldMutatingUpdateProcessor.SELECT_NO_FIELDS;
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest request, SolrQueryResponse response, UpdateRequestProcessor next) {
        return new FieldValueMutatingUpdateProcessor(this.getSelector(), next){

            @Override
            protected Object mutateValue(Object src) {
                if (src instanceof CharSequence) {
                    CharSequence txt = (CharSequence)src;
                    return RegexReplaceProcessorFactory.this.pattern.matcher(txt).replaceAll(RegexReplaceProcessorFactory.this.replacement);
                }
                return src;
            }
        };
    }
}

