/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateShardHandler {
    private static Logger log = LoggerFactory.getLogger(UpdateShardHandler.class);
    private ThreadPoolExecutor cmdDistribExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DefaultSolrThreadFactory("cmdDistribExecutor"));
    private final HttpClient client;

    public UpdateShardHandler(int distribUpdateConnTimeout, int distribUpdateSoTimeout) {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("maxConnections", 500);
        params.set("maxConnectionsPerHost", 16);
        params.set("socketTimeout", distribUpdateSoTimeout);
        params.set("connTimeout", distribUpdateConnTimeout);
        this.client = HttpClientUtil.createClient((SolrParams)params);
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public ThreadPoolExecutor getCmdDistribExecutor() {
        return this.cmdDistribExecutor;
    }

    public void close() {
        try {
            ExecutorUtil.shutdownNowAndAwaitTermination((ExecutorService)this.cmdDistribExecutor);
        }
        catch (Throwable e) {
            SolrException.log((Logger)log, (Throwable)e);
        }
        this.client.getConnectionManager().shutdown();
    }
}

