/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSLeafIndexImpl;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.cas.impl.LowLevelIteratorWrapper;
import org.apache.uima.internal.util.ComparableIntIterator;
import org.apache.uima.internal.util.ComparableIntPointerIterator;
import org.apache.uima.internal.util.IntComparator;
import org.apache.uima.internal.util.IntPointerIterator;
import org.apache.uima.internal.util.rb_trees.CompIntArrayRBT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FSRBTIndex<T extends FeatureStructure>
extends FSLeafIndexImpl<T> {
    private CompIntArrayRBT tree = null;

    public FSRBTIndex(CASImpl cas, Type type, int indexType) {
        super(cas, type, indexType);
    }

    @Override
    boolean init(FSIndexComparator comp) {
        boolean rc = super.init(comp);
        this.tree = new CompIntArrayRBT(this);
        return rc;
    }

    @Override
    public void flush() {
        this.tree.flush();
    }

    @Override
    boolean insert(int fs) {
        this.tree.insertKeyWithDups(fs);
        return true;
    }

    @Override
    public IntPointerIterator refIterator() {
        return this.tree.pointerIterator();
    }

    ComparableIntIterator refIterator(IntComparator comp) {
        return this.tree.iterator(comp);
    }

    @Override
    public ComparableIntPointerIterator pointerIterator(IntComparator comp, int[] detectIllegalIndexUpdates, int typeCode) {
        return this.tree.pointerIterator(comp, detectIllegalIndexUpdates, typeCode);
    }

    @Override
    protected IntPointerIterator refIterator(int fsCode) {
        return this.tree.pointerIterator(fsCode);
    }

    @Override
    public boolean contains(FeatureStructure fs) {
        return this.tree.containsKey(((FeatureStructureImpl)fs).getAddress());
    }

    @Override
    public FeatureStructure find(FeatureStructure fs) {
        FeatureStructureImpl fsi = (FeatureStructureImpl)fs;
        int resultAddr = this.tree.getKeyForNode(this.tree.findKey(fsi.getAddress()));
        if (resultAddr > 0) {
            return fsi.getCASImpl().createFS(resultAddr);
        }
        return null;
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    @Override
    public void deleteFS(FeatureStructure fs) {
        int addr = ((FeatureStructureImpl)fs).getAddress();
        this.tree.deleteKey(addr);
    }

    @Override
    public LowLevelIterator ll_iterator() {
        return new LowLevelIteratorWrapper(this.tree.pointerIterator(), this);
    }

    @Override
    void remove(int fs) {
        this.tree.deleteKey(fs);
    }
}

