/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.set;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.mahout.math.function.ObjectProcedure;
import org.apache.mahout.math.set.AbstractSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenHashSet<T>
extends AbstractSet
implements Set<T> {
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;
    protected static final char NO_KEY_VALUE = '\u0000';
    private Object[] table;
    private byte[] state;
    private int freeEntries;

    public OpenHashSet() {
        this(277);
    }

    public OpenHashSet(int initialCapacity) {
        this(initialCapacity, 0.2, 0.5);
    }

    public OpenHashSet(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    @Override
    public void clear() {
        Arrays.fill(this.state, 0, this.state.length - 1, (byte)0);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    @Override
    public Object clone() {
        OpenHashSet copy = (OpenHashSet)super.clone();
        copy.table = (Object[])copy.table.clone();
        copy.state = (byte[])copy.state.clone();
        return copy;
    }

    @Override
    public boolean contains(Object key) {
        return this.indexOfKey(key) >= 0;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        if (this.table.length < minCapacity) {
            int newCapacity = this.nextPrime(minCapacity);
            this.rehash(newCapacity);
        }
    }

    public boolean forEachKey(ObjectProcedure<T> procedure) {
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || procedure.apply(this.table[i])) continue;
            return false;
        }
        return true;
    }

    protected int indexOfInsertion(T key) {
        Object[] tab = this.table;
        byte[] stat = this.state;
        int length = tab.length;
        int hash = key.hashCode() & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (stat[i] == 1 && tab[i] != key) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (stat[i] == 2) {
            int j = i;
            while (stat[i] != 0 && (stat[i] == 2 || tab[i] != key)) {
                if ((i -= decrement) >= 0) continue;
                i += length;
            }
            if (stat[i] == 0) {
                i = j;
            }
        }
        if (stat[i] == 1) {
            return -i - 1;
        }
        return i;
    }

    protected int indexOfKey(T key) {
        Object[] tab = this.table;
        byte[] stat = this.state;
        int length = tab.length;
        int hash = key.hashCode() & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (!(stat[i] == 0 || stat[i] != 2 && key.equals(tab[i]))) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (stat[i] == 0) {
            return -1;
        }
        return i;
    }

    public void keys(List<T> list) {
        list.clear();
        Object[] tab = this.table;
        byte[] stat = this.state;
        int i = tab.length;
        while (i-- > 0) {
            if (stat[i] != 1) continue;
            list.add(tab[i]);
        }
    }

    @Override
    public boolean add(Object key) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
            return this.add(key);
        }
        this.table[i] = key;
        if (this.state[i] == 0) {
            --this.freeEntries;
        }
        this.state[i] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
            return this.add(key);
        }
        return true;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.table.length;
        Object[] oldTable = this.table;
        byte[] oldState = this.state;
        Object[] newTable = new Object[newCapacity];
        byte[] newState = new byte[newCapacity];
        this.lowWaterMark = this.chooseLowWaterMark(newCapacity, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(newCapacity, this.maxLoadFactor);
        this.table = newTable;
        this.state = newState;
        this.freeEntries = newCapacity - this.distinct;
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldState[i] != 1) continue;
            Object element = oldTable[i];
            int index = this.indexOfInsertion(element);
            newTable[index] = element;
            newState[index] = 1;
        }
    }

    @Override
    public boolean remove(Object key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return false;
        }
        this.state[i] = 2;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int newCapacity = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    @Override
    protected void setUp(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        int capacity = initialCapacity;
        super.setUp(capacity, minLoadFactor, maxLoadFactor);
        capacity = this.nextPrime(capacity);
        if (capacity == 0) {
            capacity = 1;
        }
        this.table = new Object[capacity];
        this.state = new byte[capacity];
        this.minLoadFactor = minLoadFactor;
        this.maxLoadFactor = capacity == Integer.MAX_VALUE ? 1.0 : maxLoadFactor;
        this.distinct = 0;
        this.freeEntries = capacity;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(capacity, this.maxLoadFactor);
    }

    @Override
    public void trimToSize() {
        int newCapacity = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.table.length > newCapacity) {
            this.rehash(newCapacity);
        }
    }

    void getInternalFactors(int[] capacity, double[] minLoadFactor, double[] maxLoadFactor) {
        capacity[0] = this.table.length;
        minLoadFactor[0] = this.minLoadFactor;
        maxLoadFactor[0] = this.maxLoadFactor;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OpenHashSet)) {
            return false;
        }
        final OpenHashSet other = (OpenHashSet)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachKey(new ObjectProcedure<T>(){

            @Override
            public boolean apply(T key) {
                return other.contains(key);
            }
        });
    }

    @Override
    public Iterator<T> iterator() {
        ArrayList keyList = new ArrayList();
        this.keys(keyList);
        return keyList.iterator();
    }

    @Override
    public Object[] toArray() {
        ArrayList keyList = new ArrayList();
        this.keys(keyList);
        return keyList.toArray();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean anyAdded = false;
        for (T o : c) {
            boolean added = this.add(o);
            anyAdded |= added;
        }
        return anyAdded;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean anyRemoved = false;
        for (Object o : c) {
            boolean removed = this.remove(o);
            anyRemoved |= removed;
        }
        return anyRemoved;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        final Collection<?> finalCollection = c;
        final boolean[] modified = new boolean[]{false};
        this.forEachKey(new ObjectProcedure<T>(){

            @Override
            public boolean apply(T element) {
                if (!finalCollection.contains(element)) {
                    OpenHashSet.this.remove(element);
                    modified[0] = true;
                }
                return true;
            }
        });
        return modified[0];
    }

    @Override
    public <T2> T2[] toArray(T2[] a) {
        ArrayList keys = new ArrayList();
        this.keys(keys);
        return keys.toArray(a);
    }

    public List<T> keys() {
        ArrayList keys = new ArrayList();
        this.keys(keys);
        return keys;
    }
}

