/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

public class LinearApproximation {
    private double[] points;
    private double argMin;
    private double argMax;
    private double step;
    private double[] arguments;

    public LinearApproximation(double[] points, double argMin, double argMax) {
        this.points = points;
        this.argMin = argMin;
        this.argMax = argMax;
        this.arguments = new double[points.length];
        this.step = (argMax - argMin) / (double)(points.length - 1);
        for (int i = 0; i < this.arguments.length; ++i) {
            this.arguments[i] = argMin + this.step * (double)i;
        }
    }

    public double getValue(double argument) {
        if (this.points.length == 1) {
            return this.points[0];
        }
        if (argument <= this.arguments[0]) {
            return this.points[0];
        }
        if (argument >= this.arguments[this.arguments.length - 1]) {
            return this.points[this.points.length - 1];
        }
        int bucket = (int)((double)(this.points.length - 1) * (argument - this.argMin) / (this.argMax - this.argMin));
        return this.points[bucket] + (argument - this.arguments[bucket]) / this.step * (this.points[bucket + 1] - this.points[bucket]);
    }
}

