/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;

public final class TokenizerDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.text.preprocessing.Tokenizer";
    public final String prefix = "Tokenizer";
    public final String title = "Performs tokenization of documents";
    public final String label = "";
    public final String description = "<p> This class saves the following results to the <code>PreprocessingContext</code>: <ul> <li><code>AllTokens.image</code></li> <li><code>AllTokens.documentIndex</code></li> <li><code>AllTokens.fieldIndex</code></li> <li><code>AllTokens.type</code></li> </ul>";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    public String getPrefix() {
        return "Tokenizer";
    }

    public String getTitle() {
        return "Performs tokenization of documents";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "<p> This class saves the following results to the <code>PreprocessingContext</code>: <ul> <li><code>AllTokens.image</code></li> <li><code>AllTokens.documentIndex</code></li> <li><code>AllTokens.fieldIndex</code></li> <li><code>AllTokens.type</code></li> </ul>";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(TokenizerDescriptor.attributes.documentFields);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(TokenizerDescriptor.attributes.documentFields);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder documentFields(Collection<String> value) {
            this.map.put("Tokenizer.documentFields", value);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo documentFields = new AttributeInfo("Tokenizer.documentFields", "org.carrot2.text.preprocessing.Tokenizer", "documentFields", "Textual fields of documents that should be tokenized and parsed for clustering.", "Document fields", "Textual fields of documents that should be tokenized and parsed for clustering", null, "Preprocessing", AttributeLevel.ADVANCED, null);

        private Attributes() {
        }
    }

    public static class Keys {
        public static final String DOCUMENT_FIELDS = "Tokenizer.documentFields";

        protected Keys() {
        }
    }
}

