/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.carrot2.core.LanguageCode;
import org.carrot2.util.MapUtils;
import org.carrot2.util.simplexml.SimpleXmlWrapperValue;
import org.carrot2.util.simplexml.SimpleXmlWrappers;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Root;

@Root(name="document")
@JsonAutoDetect(value={JsonMethod.NONE})
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public final class Document {
    public static final String TITLE = "title";
    public static final String SUMMARY = "snippet";
    public static final String CONTENT_URL = "url";
    public static final String CLICK_URL = "click-url";
    public static final String THUMBNAIL_URL = "thumbnail-url";
    public static final String SIZE = "size";
    public static final String SCORE = "score";
    public static final String SOURCES = "sources";
    public static final String LANGUAGE = "language";
    public static final String PARTITIONS = "partitions";
    private final Map<String, Object> fields = Maps.newHashMap();
    private final Map<String, Object> fieldsView = Collections.unmodifiableMap(this.fields);
    @Attribute(required=false)
    Integer id;
    private ArrayList<IDocumentSerializationListener> serializationListeners;
    public static final Comparator<Document> BY_ID_COMPARATOR = Ordering.natural().nullsFirst().onResultOf((Function)DocumentToId.INSTANCE);

    public Document() {
    }

    public Document(String title) {
        this(title, null);
    }

    public Document(String title, String summary) {
        this(title, summary, (String)null);
    }

    public Document(String title, String summary, LanguageCode language) {
        this(title, summary, null, language);
    }

    public Document(String title, String summary, String contentUrl) {
        this(title, summary, contentUrl, null);
    }

    public Document(String title, String summary, String contentUrl, LanguageCode language) {
        this.setField(TITLE, title);
        this.setField(SUMMARY, summary);
        if (StringUtils.isNotBlank((String)contentUrl)) {
            this.setField(CONTENT_URL, contentUrl);
        }
        if (language != null) {
            this.setField(LANGUAGE, (Object)language);
        }
    }

    public Document(String title, String summary, String contentUrl, LanguageCode language, int id) {
        this(title, summary, contentUrl, language);
        this.id = id;
    }

    @JsonProperty
    public Integer getId() {
        return this.id;
    }

    @JsonProperty
    @Element(required=false)
    public String getTitle() {
        return (String)this.getField(TITLE);
    }

    @Element(required=false)
    public Document setTitle(String title) {
        return this.setField(TITLE, title);
    }

    @JsonProperty(value="snippet")
    @Element(name="snippet", required=false)
    public String getSummary() {
        return (String)this.getField(SUMMARY);
    }

    @Element(name="snippet", required=false)
    public Document setSummary(String summary) {
        return this.setField(SUMMARY, summary);
    }

    @JsonProperty(value="url")
    @Element(name="url", required=false)
    public String getContentUrl() {
        return (String)this.getField(CONTENT_URL);
    }

    @Element(name="url", required=false)
    public Document setContentUrl(String contentUrl) {
        return this.setField(CONTENT_URL, contentUrl);
    }

    @JsonProperty
    @ElementList(entry="source", required=false)
    public List<String> getSources() {
        return (List)this.getField(SOURCES);
    }

    @ElementList(entry="source", required=false)
    public Document setSources(List<String> sources) {
        return this.setField(SOURCES, sources);
    }

    public LanguageCode getLanguage() {
        return (LanguageCode)((Object)this.getField(LANGUAGE));
    }

    public Document setLanguage(LanguageCode language) {
        return this.setField(LANGUAGE, (Object)language);
    }

    @Attribute(name="score", required=false)
    public Double getScore() {
        return (Double)this.getField(SCORE);
    }

    @Attribute(name="score", required=false)
    public Document setScore(Double score) {
        return this.setField(SCORE, score);
    }

    @JsonProperty(value="language")
    @Attribute(required=false, name="language")
    private String getLanguageIsoCode() {
        LanguageCode language = this.getLanguage();
        return language != null ? language.getIsoCode() : null;
    }

    @Attribute(required=false, name="language")
    private void setLanguageIsoCode(String languageIsoCode) {
        if (languageIsoCode != null) {
            LanguageCode language = LanguageCode.forISOCode(languageIsoCode);
            if (language != null) {
                this.setLanguage(language);
            } else {
                this.setLanguage(LanguageCode.valueOf(languageIsoCode));
            }
        } else {
            this.setLanguage(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonProperty(value="fields")
    private Map<String, Object> getOtherFields() {
        HashMap otherFields;
        Document document = this;
        synchronized (document) {
            otherFields = Maps.newHashMap(this.fields);
        }
        otherFields.remove(TITLE);
        otherFields.remove(SUMMARY);
        otherFields.remove(CONTENT_URL);
        otherFields.remove(SOURCES);
        otherFields.remove(LANGUAGE);
        otherFields.remove(SCORE);
        this.fireSerializationListeners(otherFields);
        return otherFields.isEmpty() ? null : otherFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ElementMap(entry="field", key="key", attribute=true, inline=true, required=false)
    private HashMap<String, SimpleXmlWrapperValue> getOtherFieldsXml() {
        HashMap<String, SimpleXmlWrapperValue> otherFieldsForSerialization;
        Document document = this;
        synchronized (document) {
            otherFieldsForSerialization = MapUtils.asHashMap(SimpleXmlWrappers.wrap(this.fields));
        }
        otherFieldsForSerialization.remove(TITLE);
        otherFieldsForSerialization.remove(SUMMARY);
        otherFieldsForSerialization.remove(CONTENT_URL);
        otherFieldsForSerialization.remove(SOURCES);
        otherFieldsForSerialization.remove(LANGUAGE);
        otherFieldsForSerialization.remove(SCORE);
        this.fireSerializationListeners(otherFieldsForSerialization);
        return otherFieldsForSerialization.isEmpty() ? null : otherFieldsForSerialization;
    }

    @ElementMap(entry="field", key="key", attribute=true, inline=true, required=false)
    private void setOtherFieldsXml(HashMap<String, SimpleXmlWrapperValue> otherFieldsForSerialization) {
        if (otherFieldsForSerialization != null) {
            this.fields.putAll(SimpleXmlWrappers.unwrap(otherFieldsForSerialization));
        }
    }

    public Map<String, Object> getFields() {
        return this.fieldsView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getField(String name) {
        Document document = this;
        synchronized (document) {
            return (T)this.fields.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document setField(String name, Object value) {
        Document document = this;
        synchronized (document) {
            this.fields.put(name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assignDocumentIds(Collection<Document> documents) {
        Collection<Document> collection = documents;
        synchronized (collection) {
            HashSet ids = Sets.newHashSet();
            int maxId = Integer.MIN_VALUE;
            for (Document document : documents) {
                if (document.id == null) continue;
                if (ids.add(document.id)) {
                    maxId = Math.max(maxId, document.id);
                    continue;
                }
                document.id = null;
            }
            maxId = Math.max(maxId, -1);
            for (Document document : documents) {
                if (document.id != null) continue;
                document.id = ++maxId;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSerializationListener(IDocumentSerializationListener listener) {
        Document document = this;
        synchronized (document) {
            if (this.serializationListeners == null) {
                this.serializationListeners = Lists.newArrayList();
            }
            this.serializationListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSerializationListeners(Map<String, ?> otherFieldsForSerialization) {
        Document document = this;
        synchronized (document) {
            if (this.serializationListeners != null) {
                for (IDocumentSerializationListener listener : this.serializationListeners) {
                    listener.beforeSerialization(this, otherFieldsForSerialization);
                }
            }
        }
    }

    public static interface IDocumentSerializationListener {
        public void beforeSerialization(Document var1, Map<String, ?> var2);
    }

    public static final class DocumentToId
    implements Function<Document, Integer> {
        public static final DocumentToId INSTANCE = new DocumentToId();

        private DocumentToId() {
        }

        public Integer apply(Document document) {
            return document.id;
        }
    }
}

