/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.engine.Engine;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.converter.ConverterUtils;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Resource;
import org.restlet.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterService
extends Service {
    public ConverterService() {
    }

    public ConverterService(boolean enabled) {
        super(enabled);
    }

    public List<Class<?>> getObjectClasses(Variant source) {
        ArrayList result = null;
        List<Class<?>> helperObjectClasses = null;
        for (ConverterHelper ch : Engine.getInstance().getRegisteredConverters()) {
            helperObjectClasses = ch.getObjectClasses(source);
            if (helperObjectClasses == null) continue;
            if (result == null) {
                result = new ArrayList();
            }
            result.addAll(helperObjectClasses);
        }
        return result;
    }

    public List<? extends Variant> getVariants(Class<?> source, Variant target) {
        return ConverterUtils.getVariants(source, target);
    }

    public Object toObject(Representation source) throws IOException {
        return this.toObject(source, null, null);
    }

    public <T> T toObject(Representation source, Class<T> target, Resource resource) throws IOException {
        T result;
        block8: {
            boolean loggable;
            result = null;
            boolean bl = loggable = resource == null ? true : resource.isLoggable();
            if (source != null && source.isAvailable() && source.getSize() != 0L) {
                ConverterHelper ch = ConverterUtils.getBestHelper(source, target, resource);
                if (ch != null) {
                    try {
                        if (loggable && Context.getCurrentLogger().isLoggable(Level.FINE)) {
                            Context.getCurrentLogger().fine("The following converter was selected for the " + source + " representation: " + ch);
                        }
                        if ((result = (T)ch.toObject(source, target, resource)) instanceof Representation) {
                            Representation resultRepresentation = (Representation)result;
                            resultRepresentation.setCharacterSet(source.getCharacterSet());
                            resultRepresentation.setMediaType(source.getMediaType());
                            resultRepresentation.getEncodings().addAll(source.getEncodings());
                            resultRepresentation.getLanguages().addAll(source.getLanguages());
                        }
                        break block8;
                    }
                    catch (Exception exception) {
                        if (loggable) {
                            Context.getCurrentLogger().log(Level.WARNING, "Unable to convert a " + source + " representation into an object of class " + target.getCanonicalName(), exception);
                        }
                        break block8;
                    }
                }
                if (loggable) {
                    Context.getCurrentLogger().warning("Unable to find a converter for this representation : " + source);
                }
            }
        }
        return result;
    }

    public Representation toRepresentation(Object source) {
        return this.toRepresentation(source, null, null);
    }

    public Representation toRepresentation(Object source, Variant target, Resource resource) {
        Representation result;
        block15: {
            result = null;
            boolean loggable = resource == null ? true : resource.isLoggable();
            ConverterHelper ch = ConverterUtils.getBestHelper(source, target, resource);
            if (ch != null) {
                try {
                    if (loggable && Context.getCurrentLogger().isLoggable(Level.FINE)) {
                        Context.getCurrentLogger().fine("Converter selected for " + source.getClass().getSimpleName() + ": " + ch.getClass().getSimpleName());
                    }
                    if (target == null) {
                        List<VariantInfo> variants = ch.getVariants(source.getClass());
                        target = variants != null && !variants.isEmpty() ? (resource != null ? resource.getConnegService().getPreferredVariant(variants, resource.getRequest(), resource.getMetadataService()) : (Variant)variants.get(0)) : new Variant();
                    }
                    if ((result = ch.toRepresentation(source, target, resource)) == null) break block15;
                    if (result.getCharacterSet() == null) {
                        result.setCharacterSet(target.getCharacterSet());
                    }
                    if (result.getMediaType() == null || !result.getMediaType().isConcrete()) {
                        if (target.getMediaType() != null && target.getMediaType().isConcrete()) {
                            result.setMediaType(target.getMediaType());
                        } else if (resource != null) {
                            result.setMediaType(resource.getMetadataService().getDefaultMediaType());
                        } else {
                            result.setMediaType(MediaType.APPLICATION_OCTET_STREAM);
                        }
                    }
                    if (result.getEncodings().isEmpty()) {
                        result.getEncodings().addAll(target.getEncodings());
                    }
                    if (result.getLanguages().isEmpty()) {
                        result.getLanguages().addAll(target.getLanguages());
                    }
                    break block15;
                }
                catch (Exception e) {
                    if (loggable) {
                        Context.getCurrentLogger().log(Level.WARNING, "Unable to convert object " + source + " to this representation variant: " + target, e);
                    }
                    break block15;
                }
            }
            if (loggable) {
                Context.getCurrentLogger().warning("Unable to find a converter for this object : " + source);
            }
        }
        return result;
    }

    public void updatePreferences(List<Preference<MediaType>> preferences, Class<?> entity) {
        for (ConverterHelper ch : Engine.getInstance().getRegisteredConverters()) {
            ch.updatePreferences(preferences, entity);
        }
    }
}

